/*------------------------------------------------------------------------------*
 * File Name: GetNBoxWithStringButton.c											*
 * Creation: GJL 6/24/2003														*
 * Purpose: Origin C file containing GetNBox example codes.						*
 * Copyright (c) OriginLab Corp.	2003-2007									*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include <GetNBox.h>

void GetNBoxWithStringButton()
{
	// Use GETN_TREE macro to declare a tree for a Tree style GetN dialog
	GETN_TREE(tr)

	// Use macro to add a checkbox node named Save having caption
	// "Save Temp Files" initialized to false (unchecked)
	GETN_CHECK(Save, "Save Temp Files", false)

	// Add a string edit box node named Path having caption "File Path",
	// initialized to string value "C:\Temp", and having a push button
	// that opens a browse dialog box
	GETN_BUTTON(Path, "File Path", "C:\Temp")

	// Open GetNBox dialog and edit input defaults passing GetN tree named tr,
	// having dialog title "GetPath", and calling the event handler function
	// DialogOnClickButtonEvent
	if( GetNBox(tr, "Get Path", NULL, NULL, DialogOnClickButtonEvent) )
		out_tree(tr);
}

// This function is executed once for each type of control on the dialog when the
// dialog is first opened and is also executed when a value on the dialog is changed 
bool DialogOnClickButtonEvent(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	if(TRGP_STR_BUTTON == nType) // If Browse button clicked then open browse dialog
	{
		string strPath = BrowseGetPath(tr.Path.strVal);
		if( !strPath.IsEmpty() )
			tr.Path.strVal = strPath;
	}
	else
		tr.Path.Enable = tr.Save.nVal; // Else disable/enable browse button

	return true; // Return true to indicate update of display is needed
}
